/*****************************************************************************
*                           Freescale Semiconductor                          *
*                                                                            *
*  Project    : AN3815 - MC56F8006 Modular Pixel Matrix                      *
*  Version    : 0.1                                                          *
*  Date       : 16/Apr/2009                                                  *
*  Authors    : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: sys.c	                                                             *
*                                                                            *
*    Interfaces with 56F8006 system registers								 * 
*                                                                            *
******************************************************************************/

/************************* Include Files *************************************/

#include "util.h"
#include "sys.h"

/********************************* Defines ***********************************/

#define DisableWatchdog()  	\
   SIM_PCE |= SIM_PCE_COP; \
   COP_CTRL &= ~COP_CTRL_CEN; \
   SIM_PCE &= ~SIM_PCE_COP

/******************************** Prototypes *********************************/

/*********************** Function's Implementation ***************************/

//! Enable PWM clock gate
void sys_enable_pwm_clk(void)
{
    // Enable PWM Peripheral Clock
    SIM_PCE |= SIM_PCE_PWM;
	
}


//! Enable high speed clock to PWM and SCI.
void sys_enable_pwm_sci_3x(void)
{
    SIM_PCR |= SIM_PCR_SCI_CR;//Multiply SCI rate by 3
    SIM_PCR |= SIM_PCR_PWM_CR;//Multiply PWM rate by 3
	
}

//! Enable PLL and other system init.
void sys_init(void)
{
    DisableWatchdog();
    enable_pll();    
	sys_enable_pwm_clk();
	sys_enable_pwm_sci_3x();	
}
